unit Upl_dlg4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBCtrls, Grids, DBGrids, StdCtrls,
  Buttons, ExtCtrls,
  Db, DBTables;

type
  TCategoryAddDlg = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    Panel3: TPanel;
    DBGrid1: TDBGrid;
    PanelC: TPanel;
    Panel5: TPanel;
    DBNavigator1: TDBNavigator;
    DBNavigator2: TDBNavigator;
    procedure FormCreate(Sender: TObject);
    procedure TblFilesCatBeforePost(DataSet: TDataSet);
    procedure FormDestroy(Sender: TObject);
  private
    Procedure CreateDBCheckBoxes;
  public
  end;

var
  CategoryAddDlg: TCategoryAddDlg;

implementation

uses DataModule;

{$R *.DFM}

procedure TCategoryAddDlg.FormCreate(Sender: TObject);
begin
  DBNavigator1.DataSource:= DM.DSFilesCat;
  DBNavigator2.DataSource:= DM.DSFilesCat;
  DBGrid1.DataSource:= DM.DSFilesCat;
  DM.TblFilesCat.BeforePost:= TblFilesCatBeforePost;
  DM.TblFilesCat.Filter:= 'FileGrpID = 1';
  DM.TblFilesCat.Filtered:= true;
  CreateDBCheckBoxes;
End;


Procedure TCategoryAddDlg.CreateDBCheckBoxes;
var
  i, k: integer;
  ChBx: TDBCheckBox;
Begin
  I:= PanelC.Height Div ( DM.TblDSPComp.RecordCount + 1 );
  k:= 0;
  DM.TblDSPComp.First;
  while not DM.TblDSPComp.EOF do
  Begin
    { create and setup DB CheckBox }
    if DM.TblFilesCat.FindField(DM.TblDSPComp.FieldByName('CompilerID').AsString) <> nil  then
    Begin
      { all compilers should have separate field in FilesCat table but ... }
      ChBx:= TDBCheckBox.Create(Self);
      ChBx.Parent:= PanelC;
      ChBx.Caption:= DM.TblDSPComp.FieldByName('Compilername').AsString;
      ChBx.Name:= DM.TblDSPComp.FieldByName('CompilerID').AsString;
      ChBx.Left:= 10;
      ChBx.Width:= PanelC.Width - 20;
      ChBx.Top:=  i * k + i Div 2;
      ChBx.Height:= i;
      ChBx.Visible:= true;
      Chbx.DataSource:= DM.DSFilesCat;
      Chbx.DataField:= DM.TblDSPComp.FieldByName('CompilerID').AsString;
      Inc(k);
    End;
    DM.TblDSPComp.Next;
  End;
End;

procedure TCategoryAddDlg.TblFilesCatBeforePost(DataSet: TDataSet);
begin
  DM.TblFilesCat.FieldByName('FileGrpID').AsInteger := 1;
end;

procedure TCategoryAddDlg.FormDestroy(Sender: TObject);
begin
  // remove what we have added in create
  DM.TblFilesCat.Filtered:= false;
  DBNavigator1.DataSource:= nil;
  DBNavigator2.DataSource:= nil;
  DBGrid1.DataSource:= nil;
end;

end.
